//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Server::Connect(char *xRemoteAddress, int RemotePort)
{
	// Connect- Connecting...

	char StatusTemp[255];
	
	SOCKADDR_IN RemoteServerSocketAddress;

	int Result	   = 0;
	int FreeClient = 0;

	SOCKET LocalSocket = 0;

	RemoteServerSocketAddress.sin_family		   = AF_INET;
	RemoteServerSocketAddress.sin_port			   = htons(RemotePort);
	RemoteServerSocketAddress.sin_addr.s_addr	   = inet_addr(xRemoteAddress);

	LocalSocket = socket(AF_INET, SOCK_STREAM, 0);

	Result = (connect(LocalSocket, (struct sockaddr *) &RemoteServerSocketAddress,sizeof(RemoteServerSocketAddress)) == 0);

	if(Result == SOCKET_ERROR)
	{
		// Connect- Socker Error.
		closesocket(LocalSocket);
		return -1;
	}

	if(Result == 0)
	{
		// Connect Failed.
		closesocket(LocalSocket);
		return -1;
	}

	FreeClient = SelectFreeClient();
	if(FreeClient == -1)
	{
		// Connect Failed. Too Many Clients.
		closesocket(LocalSocket);
		return -1;
	}

    if(NextClientID == 10000) NextClientID = 0;
    ClientID[FreeClient] = NextClientID++;
    Connected[FreeClient] = true;
	Socket[FreeClient]	 = LocalSocket;

	Connections++;

    sprintf(StatusTemp, "(%d) Connected[%d] from %s on port %d. Client[%d]", ClientID[FreeClient], Connections, xRemoteAddress, RemotePort, FreeClient);
    WriteLog(StatusTemp);

    CTI.MyServer = this;
    CTI.Client = FreeClient;

    SYSTEMTIME ST;
    GetLocalTime(&ST);
    DisconnectTime[FreeClient] = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);
    DisconnectTime[FreeClient] = (DisconnectTime[FreeClient] + MAX_CONNECT_SECONDS);

    IsClientThreadActive[CTI.Client] = false;
    Client_Thread_Handle[CTI.Client] = CreateThread(NULL, 0, Client_Thread, (LPVOID)&CTI, 0, &Client_Thread_ID[CTI.Client]);
    while(!IsClientThreadActive[CTI.Client])
        Sleep(1);

    CTI.MyServer = NULL;
    CTI.Client = -1;

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


